/*+ CommPort.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CCommPort class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef COMM_PORT_H
#define COMM_PORT_H

#if _MSC_VER > 1000
#pragma once
#endif 


/*---------------------------------------------------------------------------*\
 |                     S I M P L E   D A T A   T Y P E S
\*---------------------------------------------------------------------------*/
typedef unsigned char   U8;                      /* Unsigned 8 bits integer  */
typedef unsigned short  U16;                     /* Unsigned 16 bits integer */
typedef signed long     S32;                     /* Signed 32 bits integer   */
typedef unsigned long   U32;                     /* Unsigned 32 bits integer */


/*---------------------------------------------------------------------------*\
 |                  C O N S T A N T S   A N D   M A C R O S
\*---------------------------------------------------------------------------*/
#define COM_BAUD_1200    1200L
#define COM_BAUD_2400    2400L
#define COM_BAUD_4800    4800L
#define COM_BAUD_9600    9600L
#define COM_BAUD_14k4    14400L
#define COM_BAUD_19k2    19200L
#define COM_BAUD_28k8    28800L
#define COM_BAUD_38k4    38400L
#define COM_BAUD_57k6    57600L
#define COM_BAUD_115k    115200L

#define COM_PARITY_NONE  0
#define COM_PARITY_ODD   1
#define COM_PARITY_EVEN  2

#define COM_DATA_BITS_4  4
#define COM_DATA_BITS_5  5
#define COM_DATA_BITS_6  6
#define COM_DATA_BITS_7  7
#define COM_DATA_BITS_8  8

#define COM_STOP_BITS_1  0
#define COM_STOP_BITS_2  2


/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CCommPort
{

public: //==== P U B L I C   M E T H O D S ===================================/

    CCommPort(CWnd* pWnd = NULL);

    bool Open   (U8, U32, U8, U8, U8);
    bool Open   ();
    bool Close  ();
    bool IsOpen (void) { return (m_hPort != INVALID_HANDLE_VALUE); }
    S32  Write  (U8*, U16);
    S32  Write  (U8);
    S32  Read   (U8*, U16);
    S32  Read   (U8*);

    U8   GetParity   (void) { return m_ucParity;   }
    U32  GetBaud     (void) { return m_ulBaud;     }
    U8   GetPort     (void) { return m_ucPortNum;  }
    U8   GetStopBits (void) { return m_ucStopBits; }
    U8   GetDataBits (void) { return m_ucDataBits; }
    bool SetPort     (U8);
    bool SetBaud     (U32);
    bool SetStopBits (U8);
    bool SetDataBits (U8);
    bool SetParity   (U8);


private: //==== P R I V A T E   M E T H O D S ================================/

    bool SetPortState (U32, U8, U8, U8);
    bool Reset();
    

private: //==== P R I V A T E   M E M B E R   V A R I A B L E S ==============/

    CWnd*      m_pParent;
    HANDLE     m_hPort;
    U8         m_ucPortNum, m_ucParity, m_ucStopBits, m_ucDataBits;
    U32        m_ulBaud;
    bool       m_bOverlapped;
    OVERLAPPED m_tOvRead, m_tOvWrite;
};

#endif
